<?php  define('EMPTY_VIEW', "<center><i title='Edit' class='fas fa-edit'></i></center>"); define('EMPTY_PNG', "data:image/png;base64,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"); $clientDir = "."; $confFile = "$clientDir/conf.abo"; $confViewFile = "$clientDir/confview.abo"; $viewFile = "$clientDir/view.abo"; $pagesFile = "$clientDir/pages.abo"; $tablesFile = "$clientDir/tables.abo"; $customFile = "$clientDir/customization.abo"; $defaultFile = "$clientDir/default.abo"; $connectionFile = "$clientDir/connection.abo"; $pdfFile = "$clientDir/pdfsettings.abo"; $DBSettingsFile = "$clientDir/dbsettings.abo"; $logFile = "$clientDir/logs.abo"; function tz_offset_to_name($offset) { $offset *= 3600; $abbrarray = timezone_abbreviations_list(); foreach ($abbrarray as $abbr) { foreach ($abbr as $city) { if ($city['offset'] == $offset) { return $city['timezone_id']; } } } return FALSE; } function appendLog($op, $table, $query) { global $cfgDefault; if (intval(@$cfgDefault["defaultCharsInLogLine"]) == 0) { $cfgDefault["defaultCharsInLogLine"] = 256; } $log = "\"".date("Y-m-d H:i:s")."\",\"$op\",\"{$_SESSION['user']}\",\"{$_SERVER['REMOTE_ADDR']}\",\"$table\",\"".substr($query, 0, $cfgDefault["defaultCharsInLogLine"])."\""; file_put_contents('logs.txt', $log.PHP_EOL , FILE_APPEND | LOCK_EX); } function tryConnect() { global $conn, $cfg, $DBSettingsFile; if (file_exists($DBSettingsFile)) { $json = file_get_contents($DBSettingsFile); $cfg = json_decode($json, true); } if (@$cfg["port"]) { if (!$cfg["localhost"]) { $cfg["localhost"] = '127.0.0.1'; } $conn = @new mysqli($cfg["localhost"], $cfg["username"], $cfg["password"], $cfg["database"], $cfg["port"]); } else { $conn = @new mysqli($cfg["localhost"], $cfg["username"], $cfg["password"], $cfg["database"]); } if ($conn->connect_errno) { return false; } $conn->set_charset($cfg["charset"]); if (@$cfg["chkNoStrictMode"]) { $conn->query("SET @@sql_mode = ''"); } if (@$cfg["timezone"]) { $tz = $cfg["timezone"]; if ($tz != '99') { $conn->query("SET GLOBAL time_zone = '$tz';"); $p = strpos($tz, ':'); $tz = substr($tz, 0, $p).".".((substr($tz, $p+1, 999)*100)/60); $tz = tz_offset_to_name($tz); if ($tz) { date_default_timezone_set($tz); } else { echo "[ERROR] Misunderstood timezone - could not translate {$cfg["timezone"]}"; exit; } } } return true; } function loadAllCfg() { global $cfgLog, $cfgView, $cfgDb, $cfgPDF, $cfgPages, $pagesFile, $cfgDefault, $cfgCustom, $cfgTables, $DBSettingsFile, $defaultFile, $customFile, $confViewFile, $tablesFile, $pdfFile, $logFile, $viewFile; $errorReturn = ""; $json = @file_get_contents($DBSettingsFile); if ($json) { $cfgDb = json_decode($json, true); } else { $errorReturn .= "dbsettings file not found<br>"; $cfgDb = []; } $json = @file_get_contents($defaultFile); if ($json) { $cfgDefault = json_decode($json, true); } else { $errorReturn .= "default file not found<br>"; $cfgDefault = []; } $json = @file_get_contents($customFile); if ($json) { $cfgCustom = json_decode($json, true); } else { $errorReturn .= "customization file not found<br>"; $cfgCustom = []; } $json = @file_get_contents($tablesFile); if ($json) { $cfgTables = json_decode($json, true); } else { $errorReturn .= "tables file not found<br>"; $cfgTables = []; } $json = @file_get_contents($viewFile); if ($json) { $cfgView = json_decode($json, true); } else { $errorReturn .= "view file not found<br>"; $cfgView = []; } $json = @file_get_contents($logFile); if ($json) { $cfgLog = json_decode($json, true); } else { $errorReturn .="logs file not found"; $cfgLog = []; } $json = @file_get_contents($pagesFile); if ($json) { $cfgPages = json_decode($json, true); } else { $errorReturn .= "pages file not found<br>"; $cfgPages = []; } $json = @file_get_contents($pdfFile); if ($json) { $cfgPDF = json_decode($json, true); } else { $errorReturn .= "PDF settings file ($pdfFile) not found<br>"; $cfgPDF = []; } return $errorReturn; } function phpDbWiz_get($what) { if ($what == 'wordToBeTranslated') return "according to the language..."; return "[undefined]"; } function phpDbWiz_getView($table, $col, $data) { global $db, $cfgDefault; $view = $db[$table][$col]["View_Mode"]; $dir = $db[$table][$col]["Upload_Dir"]; if (!$dir) $dir = $cfgDefault["uploadDir"]; if (mb_substr($dir, -1) == '/') $dir = mb_substr($dir, 0, strlen($dir)-1); $link = $db[$table][$col]["Link_To_Table"]; $t = $db[$table][$col]["MySQL_Type"]; if (!$view) { if (strtoupper(substr($t,0,4))=='ENUM') { if ($db[$table][$col]["View_Aux1"]) { $token = substr($t, 5, strlen($t)-5-1); $token = explode(",",$token); for($i=0;$i<count($token);$i++) { $token[$i] = str_replace("'", "", $token[$i]); } $tokenAliases = explode(",",$db[$table][$col]["View_Aux1"]); for($i=0;$i<count($tokenAliases);$i++) { if ($token[$i] == $data) return $tokenAliases[$i]; } return "[ERROR] ENUM Aliases for table [$table] column [$col] not found! Please report to whoever created this autobackoffice!"; } else { } } if (substr($t,0,3)=='bit') { return decbin($data); } if ($t == 'TIMESTAMP') { return "timestamp"; } if ( $t == 'GEOMETRY' || $t == 'POINT' || $t == 'LINESTRING' || $t == 'POLYGON' || $t == 'MULTIPOINT' || $t == 'MULTILINESTRING' || $t == 'MULTIPOLYGON' || $t == 'GEOMETRYCOLLECTION' ) { return htmlentities($data); } if ( $t == 'BINARY' || $t == 'VARBINARY' || $t == 'BLOB' || $t == 'TINYBLOB' || $t == 'MEDIUMBLOB' || $t == 'LONGBLOB' ) { return htmlentities(substr(base64_encode($data),0,20)); } if ($db[$table][$col]["Edit_Mode"] == 'file') { return htmlentities($data); } } if ($view == 'custom_php') { include("view/$table.$col.php"); return htmlentities($data); } if ($view == 'print_N_chars') { $chars = mb_substr($data, 0, $db[$table][$col]["View_Aux1"]); if (mb_strlen($chars) < mb_strlen($data)) $chars .= " [...]"; return htmlentities($chars); } if ($view == 'php_date') { return @date("{$db[$table][$col]["View_Aux1"]}", strtotime($data)); } if ($view == 'base64_full') { return base64_encode($data); } if ($view == 'base64_cut') { return base64_encode(substr($data, 0, 10)); } if ($view == 'color_picker') { $data = htmlentities($data); return "<span style='background-color:$data'>&nbsp;&nbsp;&nbsp;</span><span style='border: 1px solid $data'>&nbsp;$data&nbsp;</span><span style='background-color:$data'>&nbsp;&nbsp;&nbsp;</span>"; } if (!$dir) $dir = "."; $lazyLoad = ''; if (@$cfgDefault['chkLazyLoad']) { $lazyLoad = 'loading=lazy'; } if($view == "img-custom") { if (!$data) $url = EMPTY_PNG; else $url = "$dir/$data"; if (!file_exists("$dir/$data")) $url = EMPTY_PNG; if (($url != EMPTY_PNG) && (@$db[$table][$col]["Edit_Aux1"])) { $url .= '?'.uniqid(); } if (!$db[$table][$col]["View_Aux1"]) { $db[$table][$col]["View_Aux1"] = 32; } return "<img $lazyLoad id='img_{$col}' width={$db[$table][$col]["View_Aux1"]} src='$url'> <script> document.getElementById('img_{$col}').src = document.getElementById('img_{$col}').src; </script>"; }; if($view == "img") { if (!$data) $url = EMPTY_PNG; else $url = "$dir/$data"; if (!file_exists("$dir/$data")) $url = EMPTY_PNG; if (($url != EMPTY_PNG) && (@$db[$table][$col]["Edit_Aux1"])) { $url .= '?'.uniqid(); } return "<img $lazyLoad id='img_{$col}' src='$url'> <script> document.getElementById('img_{$col}').src = document.getElementById('img_{$col}').src; </script>"; }; if($view == "img-xs") { if (!$data) $url = EMPTY_PNG; else $url = "$dir/$data"; if (!file_exists("$dir/$data")) $url = EMPTY_PNG; if (($url != EMPTY_PNG) && (@$db[$table][$col]["Edit_Aux1"])) { $url .= "?v=".Date("Y.m.d.G.i.s"); } return "<img $lazyLoad id='img_{$col}' width=64 src='$url'><script> document.getElementById('img_{$col}').src = document.getElementById('img_{$col}').src; </script>"; }; if($view == "img-s") { if (!$data) $url = EMPTY_PNG; else $url = "$dir/$data"; if (!file_exists("$dir/$data")) $url = EMPTY_PNG; if (($url != EMPTY_PNG) && (@$db[$table][$col]["Edit_Aux1"])) { $url .= '?'.uniqid(); } return "<img $lazyLoad id='img_{$col}' width=128 src='$url'> <script> document.getElementById('img_{$col}').src = document.getElementById('img_{$col}').src; </script>"; }; if($view == "img-m") { if (!$data) $url = EMPTY_PNG; else $url = "$dir/$data"; if (!file_exists("$dir/$data")) $url = EMPTY_PNG; if (($url != EMPTY_PNG) && (@$db[$table][$col]["Edit_Aux1"])) { $url .= '?'.uniqid(); } return "<img $lazyLoad id='img_{$col}' width=256 src='$url'> <script> document.getElementById('img_{$col}').src = document.getElementById('img_{$col}').src; </script>"; }; if($view == "img-l") { if (!$data) $url = EMPTY_PNG; else $url = "$dir/$data"; if (!file_exists("$dir/$data")) $url = EMPTY_PNG; if (($url != EMPTY_PNG) && (@$db[$table][$col]["Edit_Aux1"])) { $url .= '?'.uniqid(); } return "<img $lazyLoad id='img_{$col}' width=512 src='$url'> <script> document.getElementById('img_{$col}').src = document.getElementById('img_{$col}').src; </script>"; }; if($view == "fullText") { return htmlentities($data); }; if ($link) { if (!$view) { $newTable = substr($link, 0, strpos($link, '/')); $newField = substr($link, strpos($link, '/')+1, 99999); if ($newField[0] == '"') { $newField = substr($newField, 1, 99999); $sql = "SELECT $newField FROM $newTable WHERE `{$db[$table][$col]["Lookup_Field"]}`='$data'"; return htmlentities(@zbSQL($sql)); } else { $sql = "SELECT `$newField` FROM $newTable WHERE `{$db[$table][$col]["Lookup_Field"]}`='$data'"; return htmlentities(@zbSQL($sql)); } } } if (@!$cfgDefault["defaultCharsInView"]) { $cfgDefault["defaultCharsInView"] = 20; } $ret = htmlentities(mb_substr($data,0,$cfgDefault["defaultCharsInView"])).(mb_strlen($data)>$cfgDefault["defaultCharsInView"]?" [...]":""); if (!$ret && $ret!='0') { return EMPTY_VIEW; } else { return $ret; } } function phpDbWiz_howToHandle($table, $column) { global $db, $cfgDefault; $mode = $db[$table][$column]["Edit_Mode"]; $link = $db[$table][$column]["Link_To_Table"]; $dir = $db[$table][$column]["Upload_Dir"]; $t = strtoupper($db[$table][$column]["MySQL_Type"]); if ( $t == 'GEOMETRY' || $t == 'POINT' || $t == 'LINESTRING' || $t == 'POLYGON' || $t == 'MULTIPOINT' || $t == 'MULTILINESTRING' || $t == 'MULTIPOLYGON' || $t == 'GEOMETRYCOLLECTION' ) { return "textarea"; } if ( $t == 'BINARY' || $t == 'VARBINARY' || $t == 'BLOB' || $t == 'TINYBLOB' || $t == 'MEDIUMBLOB' || $t == 'LONGBLOB' ) { return "base64"; } if (!$mode && $link) { return "comboBoxLink"; } if ($dir && $mode=='upload') { return "upload"; } if ($dir && $mode=='file') { return "file"; } if (!$mode) { if (($t == 'TEXT') || ($t == 'MEDIUMTEXT') || ($t == 'LONGTEXT')) { if (@$cfgDefault['chkDefaultHTMLText']) { return "html"; } else { return NULL; } } return NULL; } return $mode; } function zbSQL($s) { global $conn; return mysqli_fetch_row($conn->query($s))[0]; } function debug($s) { echo "<pre>"; print_r($s); echo "</pre>"; } function fDebug($s) { file_put_contents('debug.txt', date('Y-m-d h:i:s',time())." ".$s.PHP_EOL , FILE_APPEND | LOCK_EX); } function JSdebug($s) { ?><script>console.log('<?php echo $s?>')</script><?php
} function h_type2txt($type_id) { static $types; if (!isset($types)) { $types = array(); $constants = get_defined_constants(true); foreach ($constants['mysqli'] as $c => $n) if (preg_match('/^MYSQLI_TYPE_(.*)/', $c, $m)) $types[$n] = $m[1]; } return array_key_exists($type_id, $types)? $types[$type_id] : NULL; } function h_flags2txt($flags_num) { static $flags; if (!isset($flags)) { $flags = array(); $constants = get_defined_constants(true); foreach ($constants['mysqli'] as $c => $n) if (preg_match('/MYSQLI_(.*)_FLAG$/', $c, $m)) if (!array_key_exists($n, $flags)) $flags[$n] = $m[1]; } $result = array(); foreach ($flags as $n => $t) if ($flags_num & $n) $result[] = $t; return implode(' ', $result); } function loadCfgConnection() { global $conn, $db, $connectionFile; if (file_exists($connectionFile)) { $json = file_get_contents($connection); $cfgConnection = json_decode($json, true); } } function loadConfig() { global $conn, $db, $confFile, $confViewFile, $dbview; if (file_exists($confFile)) { $json = file_get_contents($confFile); $db = json_decode($json, true); } else { echo "Configuration file not found."; } if (file_exists($confViewFile)) { $json = file_get_contents($confViewFile); $dbview = json_decode($json, true); } else { $dbview = []; $result = $conn->query("SHOW FULL TABLES WHERE table_type = 'VIEW'"); while($r = $result->fetch_array(MYSQLI_NUM)) { $table = $r[0]; $sql = "SELECT COLUMN_TYPE, COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_NAME = '$table'"; $result2 = $conn->query($sql); while($row = mysqli_fetch_array($result2)){ error_log("setdefault={$row["COLUMN_NAME"]}, {$row["COLUMN_TYPE"]}"); setDefaultParameters($table, $row["COLUMN_NAME"], $row["COLUMN_TYPE"], 'view'); } } $json = json_encode($dbview); file_put_contents($confViewFile, $json); } } function editSingleField($table, $colname, $coltype, $primary, $primaryValue, $value) { global $conn, $db, $cfgDefault; $ret = "NOT HANDLED"; if ($handleAs = phpDbWiz_howToHandle($table, $colname)) { if ($handleAs == 'color_picker') { ?>
        <input type=color name=color id=color_<?=$table."_".$colname?> value='<?=$value?>'><br>
<?php
 $ret = "_v('color_{$table}_{$colname}');"; } else if ($handleAs == 'base64') { ?><textarea class="form-control" id="textarea_<?php echo "{$table}_{$colname}"?>" name="textarea_<?php echo "{$table}_{$colname}"?>" rows="4"><?php echo base64_encode($value)?></textarea><?php
 $ret = "atob(_v('textarea_{$table}_{$colname}'));"; } else if ($handleAs=='autocomplete') { ?>
<input class=form-control type=text id="<?="autocomplete_{$table}_{$colname}"?>" name="<?="autocomplete_{$table}_{$colname}"?>" list="<?="autocomplete_{$table}_{$colname}_list"?>" value="<?=htmlentities($value)?>">
<datalist id="<?="autocomplete_{$table}_{$colname}_list"?>">
<?php
 $s = "SELECT DISTINCT($colname) AS col FROM $table"; $result = $conn->query($s); while ($r = $result->fetch_array(MYSQLI_ASSOC)) { ?>
  	<option><?=$r['col']?></option>
<?php
 } ?>
</datalist>
<?php
 $ret = "_v('autocomplete_{$table}_{$colname}');"; } else if ($handleAs == 'textarea') { $textAreaClass = 'form-control'; if ($db[$table][$colname]["Edit_Aux1"]) { $textAreaClass = ''; $paramTextArea = explode(",", $db[$table][$colname]["Edit_Aux1"]); } ?><textarea class='<?=$textAreaClass?>' rows='<?=@$paramTextArea[0]?>' cols='<?=@$paramTextArea[1]?>' id="textarea_<?php echo "{$table}_{$colname}"?>" name="textarea_<?php echo "{$table}_{$colname}"?>"><?php echo htmlentities($value)?></textarea><?php
 $ret = "_v('textarea_{$table}_{$colname}');"; } else if ($handleAs == 'html') { ?><div id='editor<?php echo "_{$table}_{$colname}"?>'></div><script>
        var toolbarOptions = [
          [{ 'font': [] }],
          [{ 'header': [1, 2, 3, 4, 5, 6, false] }],  
          [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
          [{ 'align': [] }],
          ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
          [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
          ['link'],  
          ['blockquote', 'code-block'],
          [{ 'list': 'ordered'}, { 'list': 'bullet' }],
          [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
          [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
          [{ 'direction': 'rtl' }],                         // text direction
          ['clean']                                         // remove formatting button
        ];
  
        var quill<?="_{$table}_{$colname}"?> = new Quill('#editor<?="_{$table}_{$colname}"?>', {
          modules: {
            toolbar: toolbarOptions
          },
          theme: 'snow'
        });  
        var value = `<?=$value?>`
        var delta = quill<?="_{$table}_{$colname}"?>.clipboard.convert(value)
        quill<?="_{$table}_{$colname}"?>.setContents(delta, 'silent')
        //quill<?="_{$table}_{$colname}"?>.focus()
      </script>
      <br>
<?php
 if (@$cfgDefault["chkRemovePFromHTML"]) { $ret = "1; var quill_aux_{$table}_{$colname} = quill_{$table}_{$colname}.root.innerHTML.replace(/<p>/gi, ''); quill_aux_{$table}_{$colname} = quill_aux_{$table}_{$colname}.replace(/<\/p>/gi,'<br>'); val = quill_aux_{$table}_{$colname};"; } else { $ret = "quill_{$table}_{$colname}.root.innerHTML;"; } } else if (($handleAs == 'upload')||($handleAs == 'file')) { $fname = $db[$table][$colname]["Upload_Dir"]; if (substr($fname, -1) <> '/') $fname .= '/'; $fname .= $value; if ($db[$table][$colname]["Width"]) { if ($handleAs == 'file') { echo "<br>Maximum file size: ".intval($db[$table][$colname]["Width"]/1024)." kB<br>"; } else { echo "<br>Forced Width: ".$db[$table][$colname]["Width"]."px<br>"; } } if ($db[$table][$colname]["Height"]) { echo "Forced Height: ".$db[$table][$colname]["Height"]."px<br>"; } echo phpDbWiz_getView($table, $colname, $value); if (($handleAs == 'upload') && (@$cfgDefault["chkletDownloadImage"]) && $value) { echo "&nbsp;&nbsp;<a class='btn btn-primary' target='_blank' download href='$fname'><i class='fa fa-download'></i>&nbsp;&nbsp;Download</a>"; } if ($handleAs == 'file') { $fsize = @filesize($fname); if ($fsize === false) { echo "<br><br><h1 style='color:white; background-color:red'>&nbsp;ERROR: <b>{$fname}</b> does not exist anymore</h1>"; } else { if ((strtoupper($db[$table][$colname]["View_Aux1"]) == 'DOWNLOAD') && $value) { echo "&nbsp;&nbsp;<a class='btn btn-primary' target='_blank' download href='$fname'><i class='fa fa-download'></i>&nbsp;&nbsp;Download</a>"; } echo "<br><br><small>"; echo "Size: ".number_format($fsize)." bytes (".round($fsize/1024)." kB or around ".round($fsize/(1024*1024),2)." MB)<br>"; echo "Last modified: " . date ("F d Y H:i:s", @filemtime($fname)); echo "</small>"; } } ?>
    <br>
    <form id="upload_form" enctype="multipart/form-data" method="post">
      <div class="row">
        <div class="col-md-12">
          <progress id="<?=$colname?>_progressBar" value="0" max="100" style="width:100%; display:none">
          </progress>
          <div id="<?=$colname?>_status">
          </div>
          <p id="<?=$colname?>_loaded_n_total">
          </p>
        </div>
      </div>
      <div class="row">
        <div class="col-md-4">
          <div class="custom-file">
            <input name="file<?=$colname?>" id="file<?=$colname?>" onchange="uploadFile('<?=$colname?>','<?=$db[$table][$colname]["Upload_Dir"]?>')" type="file" class="custom-file-input" id="customFile">
            <label class="custom-file-label" for="customFile">Choose file to Upload</label>
          </div>
        </div>
<?php
 if ($handleAs == 'upload') { ?>        
        <div class="col-md-4">
          <button onclick="loadImgFromServer('<?=$table?>', '<?=$colname?>', '<?=$primary?>', '<?=$primaryValue?>'); return false;" class='btn btn-primary btn-block'>
            <i class='fa fa-server'></i>&nbsp;&nbsp;From server </button>
        </div>
        <div class="col-md-4">
          <button class='btn btn-danger btn-block' onclick="deleteFile('<?=$table?>', '<?=$colname?>', '<?=$primary?>', '<?=$primaryValue?>'); return false;">
          <i class='fa fa-trash'></i>&nbsp;&nbsp;Remove </button>&nbsp;&nbsp;
        </div>
<?php
 if (@$cfgDefault['chkletGrabUrl']) { ?>            
        <div class="col-md-4">
          <button class='btn btn-warning btn-block' onclick="grabUrl(); return false;">
          <i class='fa fa-link'></i>&nbsp;&nbsp;Grab URL</button>&nbsp;&nbsp;
        </div>
<?php
 } } ?>        
      </div>
      <div id='serverimg_<?=$table?>_<?=$colname?>'>
      </div>
    </form>
<?php  } else if ($handleAs=='integer') { $max = intval($db[$table][$colname]["Edit_Aux1"]); if ($max == 0) $max = 9; ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumber(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if ($handleAs=='float') { $max = intval($db[$table][$colname]["Edit_Aux1"]); if ($max == 0) $max = 9; ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumberFloat(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if ($handleAs == 'comboBoxLink') { $link = $db[$table][$colname]["Link_To_Table"]; $lookup = $db[$table][$colname]["Lookup_Field"]; $newTable = substr($link, 0, strpos($link, '/')); $newField = substr($link, strpos($link, '/')+1, 99999); $mandatory = @$db[$table][$colname]["Mandatory"]; if (!$mandatory) $mandatory = 'No'; if ($newField[0] == '"') $newField = substr($newField, 1, 99999); $sql = "SELECT $newField, $lookup FROM $newTable"; $result = $conn->query($sql); echo "<select class='form-control' id='combo_{$table}_{$colname}'>"; if ($mandatory == 'No') { $valueShown = @$db[$table][$colname]["View_Aux1"]; if (!$valueShown) $valueShown = '-----'; $valueStored = @$db[$table][$colname]["Edit_Aux1"]; if (!$valueStored) $valueStored = 0; echo "<option value='$valueStored'>$valueShown</option>"; } while($el = mysqli_fetch_array($result)){ $selected = ''; if ($el[$lookup] == $value) $selected = "selected"; if ($el[$newField] == '') continue; echo "<option $selected value='".$el[$lookup]."'>".strip_tags($el[$newField])."</option>"; } echo "</select>"; $ret = "_v('combo_{$table}_{$colname}');"; } else if ($handleAs == 'tinytext') { ?><input class="form-control" type=text maxlength=127 id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else echo "<h1>ERROR - Unhandled HandleAs case ($handleAs)</h1>"; } else { if ($coltype=='date') { $id = "tinytext_{$table}_{$colname}"; ?><div class="form-group"><div class="input-group date" data-target-input="nearest"><div class="input-group-append" data-target="#<?php echo $id?>" data-toggle="datetimepicker"><input type="text" value="<?php echo htmlentities($value)?>" class="form-control datetimepicker-input" data-target="#<?php echo $id?>" id="<?php echo $id?>"/><div class="input-group-text"><i class="fa fa-calendar"></i></div></div></div></div><script>
          $(function () {
            $('#<?php echo $id?>').datetimepicker({
              format: 'YYYY-MM-DD',
              ShowUpDown: true,
              date: '<?php echo $value?>'
            });
          });
        </script><?php
 $ret = "_v('$id');"; } else if ($coltype=='datetime') { $id = "tinytext_{$table}_{$colname}"; ?><div class="form-group"><div class="input-group date" data-target-input="nearest"><div class="input-group-append" data-target="#<?php echo $id?>" data-toggle="datetimepicker"><input type="text" value="<?php echo htmlentities($value)?>" class="form-control datetimepicker-input" data-target="#<?php echo $id?>" id="<?php echo $id?>"/><div class="input-group-text"><i class="fa fa-calendar"></i></div></div></div></div><script>
          $(function () {
            $('#<?php echo $id?>').datetimepicker({
              format: 'YYYY-MM-DD HH:mm:ss',
              timerPicker: true,
              timePicker24Hour: true,
              date: '<?php echo $value?>',
              sideBySide: true,
              ShowUpDown: true
            });
          });
        </script><?php
 $ret = "_v('$id');"; } else if ($coltype=='timestamp') { $id = "tinytext_{$table}_{$colname}"; ?><div class="form-group"><div class="input-group date" data-target-input="nearest"><div class="input-group-append" data-target="#<?php echo $id?>" data-toggle="datetimepicker"><input type="text" value="<?php echo htmlentities($value)?>" class="form-control datetimepicker-input" data-target="#<?php echo $id?>" id="<?php echo $id?>"/><div class="input-group-text"><i class="fa fa-calendar"></i></div></div></div></div><script>
                $(function () {
                  $('#<?php echo $id?>').datetimepicker({
                    format: 'YYYY-MM-DD HH:mm:ss',
                    timerPicker: true,
                    timePicker24Hour: true,
                    sideBySide: true,
                    date: '<?php echo $value?>',
                    sideBySide: true,
                    ShowUpDown: true
                  });
                });
              </script><?php
 $ret = "_v('$id');"; } else if (0) { ?><input class="form-control" type=text maxlength=8 id=<?php echo "tinytext_{$table}_{$colname}"?> name=<?php echo "tinytext_{$table}_{$colname}"?> value="<?php echo htmlentities($value)?>" onkeypress="return isNumberTime(event, '<?php echo "tinytext_{$table}_{$colname}"?>')" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if ($coltype=='time') { $id = "tinytext_{$table}_{$colname}"; ?>
        <div class="form-group"><div class="input-group date" data-target-input="nearest"><div class="input-group-append" data-target="#<?php echo $id?>"><input type="time" value="<?php echo htmlentities($value)?>" class="form-control" data-target="#<?php echo $id?>" id="<?php echo $id?>"/><div class="input-group-text"><i class="fa fa-clock"></i></div></div></div></div>
<?php
 $ret = "_v('$id');"; } else if ($coltype=='tinytext') { ?><input class="form-control" type=text maxlength=127 id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (($coltype=='text') || ($coltype=='mediumtext') || ($coltype=='longtext')) { ?><textarea class="form-control" id="textarea_<?php echo "{$table}_{$colname}"?>" name="field" rows="4"><?php echo htmlentities($value)?></textarea><?php
 $ret = "_v('textarea_{$table}_{$colname}');"; } else if (substr($coltype,0,7)=='decimal') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumberFloat(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,3)=='int') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumber(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,7)=='tinyint') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumber(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,8)=='smallint') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumber(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,9)=='mediumint') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumber(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,6)=='bigint') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumber(event)" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,3)=='bit') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); if ($max == 0) $max = 1; ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities(decbin($value))?>" onkeypress="return isBinaryNumber(event)" onpaste="return false;"><?php
 $ret = "parseInt(_v('tinytext_{$table}_{$colname}'), 2);"; } else if ((substr($coltype,0,5)=='float') || (substr($coltype,0,6)=='double')) { $max = 11; ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>" onkeypress="return isNumberFloat(event, '<?php echo "tinytext_{$table}_{$colname}"?>')" onpaste="return false;"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,4)=='char') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?php echo $max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,7)=='varchar') { $max = intval(substr($coltype, 1+strpos($coltype,'('))); ?><input class="form-control" type=text maxlength=<?=$max?> id=<?php echo "tinytext_{$table}_{$colname}"?> name=field value="<?php echo htmlentities($value)?>"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } else if (substr($coltype,0,4)=='enum') { $token = substr($coltype, 5, strlen($coltype)-5-1); $token = explode(",",$token); for($i=0;$i<count($token);$i++) { $token[$i] = str_replace("'", "", $token[$i]); } if ($db[$table][$colname]["View_Aux1"]) { $tokenAliases = explode(",",$db[$table][$colname]["View_Aux1"]); ?><div class="form-group"><select id='<?php echo "select_{$table}_{$colname}"?>' class="form-control"><?php
 for($i=0;$i<count($tokenAliases);$i++) { $selected = ($token[$i] == $value) ? "selected" : ""; echo "<option $selected value='{$token[$i]}'>".htmlentities($tokenAliases[$i])."</option>"; } ?></select></div>
<?php  } else { ?><div class="form-group"><select id='<?php echo "select_{$table}_{$colname}"?>' class="form-control"><?php
 for($i=0;$i<count($token);$i++) { $selected = ($token[$i] == $value) ? "selected" : ""; echo "<option $selected>".htmlentities($token[$i])."</option>"; } ?></select></div>
<?php
 } ?>      
<?php
 $ret = "_v('select_{$table}_{$colname}');"; } else if (substr($coltype,0,3)=='set') { $tokenFirst = substr($coltype, 4, strlen($coltype)-4-1); $token = []; $token = explode(",",$tokenFirst); for($i=0;$i<count($token);$i++) $token[$i] = str_replace("'", "", $token[$i]); $token[] = ''; ?><div class="form-group"><select id='<?php echo "select_{$table}_{$colname}"?>' class="form-control"><?php
 for($i=0;$i<count($token);$i++) { $selected = ($token[$i] == $value) ? "selected" : ""; echo "<option $selected>".htmlentities($token[$i])."</option>"; } ?></select></div><?php
 $ret = "_v('select_{$table}_{$colname}');"; } else { ?><input class='form-control' type=text id=<?php echo "tinytext_{$table}_{$colname}"?> name=<?php echo "tinytext_{$table}_{$colname}"?> value="<?php echo htmlentities($value)?>"><?php
 $ret = "_v('tinytext_{$table}_{$colname}');"; } } return $ret; } ?>